//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

//*** FOR DERBY DB ***//

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Top10Sales");
report.setReport("/com/openbravo/reports/top10sales");
report.setResourceBundle("com/openbravo/reports/top10sales_messages");

report.setSentence(
            "SELECT " +
			"PRODUCTS.REFERENCE,PRODUCTS.NAME,PRODUCTS.PRICEBUY,PRODUCTS.PRICESELL, " +
			"ROUND(SUM(TICKETLINES.UNITS)) AS UNITS, " +
                        "ROUND(SUM(TICKETLINES.PRICE * TICKETLINES.UNITS)) AS SUBTOTAL, " +
                        "ROUND(SUM((TICKETLINES.PRICE * TICKETLINES.UNITS) * TAXES.RATE)) As TAXES, " +
                        "ROUND(SUM(TICKETLINES.PRICE * TICKETLINES.UNITS) + SUM((TICKETLINES.PRICE * TICKETLINES.UNITS) * TAXES.RATE)) AS GROSSTOTAL " +
			"FROM TICKETLINES " +
			"LEFT OUTER JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID " +
			"LEFT OUTER JOIN TICKETS ON TICKETS.ID = TICKETLINES.TICKET " +
                        "LEFT OUTER JOIN RECEIPTS ON RECEIPTS.ID = TICKETS.ID, TAXES " +
			"WHERE RECEIPTS.ID = TICKETS.ID " +
                        "AND TICKETS.ID = TICKETLINES.TICKET " +
                        "AND TICKETLINES.PRODUCT = PRODUCTS.ID " +
                        "AND TICKETLINES.TAXID = TAXES.ID " +
                        "AND ?(QBF_FILTER) " +
			"GROUP BY PRODUCTS.REFERENCE, PRODUCTS.NAME,PRODUCTS.PRICEBUY,PRODUCTS.PRICESELL " +
			"ORDER BY GROSSTOTAL DESC " +
			"LIMIT 10");
			
report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("REFERENCE", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("UNITS", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("PRICEBUY", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("PRICESELL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("SUBTOTAL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TAXES", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("GROSSTOTAL", com.openbravo.data.loader.Datas.DOUBLE);
report;

