//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.SaleCatalog");
report.setReport("/com/openbravo/reports/salecatalog");
report.setResourceBundle("com/openbravo/reports/salecatalog_messages");

report.setSentence(
"SELECT " +
"  PRODUCTS.ID, " +
"  PRODUCTS.REFERENCE, " +
"  PRODUCTS.CODE, " +
"  PRODUCTS.CODETYPE, " +
"  PRODUCTS.NAME, " +
"  PRODUCTS.PRICESELL, " +
"  PRODUCTS.IMAGE, " +
"  TC.ID AS TAXCAT, " +
"  CATEGORIES.NAME AS CATEGORYNAME " +
"FROM " +
"  PRODUCTS LEFT OUTER JOIN CATEGORIES ON " +
"  PRODUCTS.CATEGORY = CATEGORIES.ID LEFT OUTER JOIN TAXCATEGORIES TC ON " +
"  PRODUCTS.TAXCAT = TC.ID, " +
"  PRODUCTS_CAT " +
"WHERE PRODUCTS.ID = PRODUCTS_CAT.PRODUCT AND ?(QBF_FILTER) " +
"ORDER BY CATEGORIES.NAME, PRODUCTS.NAME");
report.addParameter("PRODUCTS.NAME");
report.addParameter("PRODUCTS.PRICEBUY");
report.addParameter("PRODUCTS.PRICESELL");
report.addParameter("PRODUCTS.CATEGORY");
report.addParameter("PRODUCTS.CODE");
report.addQBFFilter(new com.openbravo.pos.ticket.ProductFilter());

report.addField("ID", com.openbravo.data.loader.Datas.STRING);
report.addField("REFERENCE", com.openbravo.data.loader.Datas.STRING);
report.addField("CODE", com.openbravo.data.loader.Datas.STRING);
report.addField("CODETYPE", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("PRICESELL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("IMAGE", com.openbravo.data.loader.Datas.IMAGE);
report.addField("TAXCAT", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORYNAME", com.openbravo.data.loader.Datas.STRING);

report;

