//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.InventoryDiffDetail");
report.setReport("/com/openbravo/reports/inventorydiffdetail");
report.setResourceBundle("com/openbravo/reports/inventorydiffdetail_messages");

report.setSentence("SELECT " +
                "LOCATIONS.ID AS LOCATIONID, LOCATIONS.NAME AS LOCATIONNAME, " +
                "PRODUCTS.REFERENCE, PRODUCTS.NAME, " +
                "STOCKDIARY.ATTRIBUTESETINSTANCE_ID, ATTRIBUTESETINSTANCE.DESCRIPTION, " +
                "PRODUCTS.CATEGORY, CATEGORIES.NAME AS CATEGORYNAME, " +
                "SUM(CASE WHEN STOCKDIARY.UNITS <0 THEN STOCKDIARY.UNITS ELSE 0 END) AS UNITSOUT, " +
                "SUM(CASE WHEN STOCKDIARY.UNITS <0 THEN STOCKDIARY.UNITS * STOCKDIARY.PRICE ELSE 0 END) AS TOTALOUT, " +
                "SUM(CASE WHEN STOCKDIARY.UNITS >=0 THEN STOCKDIARY.UNITS ELSE 0 END) AS UNITSIN, " +
                "SUM(CASE WHEN STOCKDIARY.UNITS >=0 THEN STOCKDIARY.UNITS * STOCKDIARY.PRICE ELSE 0 END) AS TOTALIN, " +
                "SUM(STOCKDIARY.UNITS) AS UNITSDIFF, " +
                "SUM(STOCKDIARY.UNITS * STOCKDIARY.PRICE) AS TOTALDIFF " +
                "FROM STOCKDIARY " +
                "JOIN LOCATIONS ON STOCKDIARY.LOCATION = LOCATIONS.ID " +
                "JOIN PRODUCTS ON PRODUCTS.ID = STOCKDIARY.PRODUCT " +
                "LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID " +
                "LEFT OUTER JOIN ATTRIBUTESETINSTANCE ON STOCKDIARY.ATTRIBUTESETINSTANCE_ID = ATTRIBUTESETINSTANCE.ID " +
                "WHERE ?(QBF_FILTER) " +
                "GROUP BY LOCATIONS.ID, LOCATIONS.NAME, PRODUCTS.REFERENCE, PRODUCTS.NAME, PRODUCTS.CATEGORY, CATEGORIES.NAME, STOCKDIARY.ATTRIBUTESETINSTANCE_ID, ATTRIBUTESETINSTANCE.DESCRIPTION " +
                "ORDER BY LOCATIONS.ID, CATEGORIES.NAME, PRODUCTS.NAME");

report.addParameter("STOCKDIARY.DATENEW");
report.addParameter("STOCKDIARY.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addParameter("LOCATIONS.ID");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsLocationWithFirst());

report.addParameter("STOCKDIARY.REASON");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsReason());

report.addField("LOCATIONID", com.openbravo.data.loader.Datas.STRING);
report.addField("LOCATIONNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("REFERENCE", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("ATTINSTANCEID", com.openbravo.data.loader.Datas.STRING);
report.addField("ATTINSTANCEDESC", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORY", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORYNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("UNITSOUT", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTALOUT", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("UNITSIN", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTALIN", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("UNITSDIFF", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTALDIFF", com.openbravo.data.loader.Datas.DOUBLE);

report;